// {"name":"ModManager","status":true,"parameters":{"name":"ModManager","version":"2.0.4"}}
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("Alert"), require("Logger"));
	else if(typeof define === 'function' && define.amd)
		define(["Alert", "Logger"], factory);
	else if(typeof exports === 'object')
		exports["ModManager"] = factory(require("Alert"), require("Logger"));
	else
		root["ModManager"] = factory(root["Alert"], root["Logger"]);
})(this, (__WEBPACK_EXTERNAL_MODULE__libs_sweetalert__, __WEBPACK_EXTERNAL_MODULE__libs_logger__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./module/errorContext.ts":
/*!********************************!*\
  !*** ./module/errorContext.ts ***!
  \********************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getErrorContext = void 0;
var logging_1 = __importDefault(__webpack_require__(/*! ./logging */ "./module/logging.ts"));
var process = __importStar(__webpack_require__(/*! process */ "process"));
var knownDlcList = {
    'Stray Pubes DLC': function () { return globalThis.DLC_HAIR; },
    'Gym DLC': function () { return globalThis.DLC_GYM; },
    'P-Cup DLC': function () { return globalThis.DLC_PCUP; }
};
function getErrorContext(error) {
    var e_1, _a;
    function getLoadedModsList(mods) {
        return mods
            .filter(function (mod) { return !mod.parameters.optional; })
            .map(function (mod) {
            return {
                name: mod.name,
                displayedName: mod.parameters.displayedName,
                version: mod.parameters.version,
                source: mod.source,
            };
        });
    }
    var dlcList = [];
    try {
        for (var _b = __values(Object.entries(knownDlcList)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var _d = __read(_c.value, 2), name_1 = _d[0], getStatus = _d[1];
            var isEnabled = getStatus() || null;
            dlcList.push({
                name: name_1,
                isEnabled: isEnabled
            });
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    var mods = getLoadedModsList(globalThis.$mods || []);
    var errorContext = {
        game: {
            version: globalThis.RemGameVersion || null,
            dlc: dlcList
        },
        device: {
            platform: process.platform,
            arch: process.arch,
            node: process.version
        },
        mods: mods,
        error: error
    };
    logging_1.default.info({ errorContext: errorContext }, 'Generated error context');
    return errorContext;
}
exports.getErrorContext = getErrorContext;


/***/ }),

/***/ "./module/errorPrinter.ts":
/*!********************************!*\
  !*** ./module/errorPrinter.ts ***!
  \********************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getFooterHtml = exports.getReportHtml = exports.getLogs = void 0;
var errorContext_1 = __webpack_require__(/*! ./errorContext */ "./module/errorContext.ts");
var logging_1 = __webpack_require__(/*! ./logging */ "./module/logging.ts");
function getErrorHtml(error) {
    var _a;
    return '<b>' + ((error === null || error === void 0 ? void 0 : error.message) || error || '').toString() + '</b><hr>' +
        (((_a = error === null || error === void 0 ? void 0 : error.stack) === null || _a === void 0 ? void 0 : _a.toString()) || '');
}
function getDlcListHtml(details) {
    var getTextStatus = function (status) {
        switch (status) {
            case null:
                return 'unknown';
            case false:
                return 'disabled';
            case true:
                return 'enabled';
        }
    };
    var dlcListItems = details.game.dlc
        .map(function (dlc) { return "<li>".concat(dlc.name, ": ").concat(getTextStatus(dlc.isEnabled)); });
    return "\n        <ul style=\"font-size: smaller\">\n            ".concat(dlcListItems.join('\n'), "\n        </ul>\n    ");
}
function getModsListHtml(details) {
    var modsListItems = details.mods
        .map(function (mod) {
        var displayedName = mod.displayedName ? "".concat(mod.displayedName, " (").concat(mod.name, ")") : mod.name;
        var version = mod.version ? " v".concat(mod.version) : '';
        return "<li>".concat(displayedName).concat(version, " (source: ").concat(mod.source, ")\n");
    });
    if (!details.mods.length) {
        return '';
    }
    return "Mods:\n        <ul style=\"font-size: smaller\">\n            ".concat(modsListItems.join('\n'), "\n        </ul>\n    ");
}
function getLogs() {
    return __awaiter(this, void 0, void 0, function () {
        var logs, logFileUrls, logFileUrls_1, logFileUrls_1_1, logUrl, logsResponse, e_1_1;
        var e_1, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    logs = '';
                    logFileUrls = [
                        logging_1.defaultLogPath,
                        '/ErrorLog.txt',
                        '/logs.txt'
                    ];
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 7, 8, 9]);
                    logFileUrls_1 = __values(logFileUrls), logFileUrls_1_1 = logFileUrls_1.next();
                    _b.label = 2;
                case 2:
                    if (!!logFileUrls_1_1.done) return [3 /*break*/, 6];
                    logUrl = logFileUrls_1_1.value;
                    return [4 /*yield*/, fetch(logUrl)];
                case 3:
                    logsResponse = _b.sent();
                    if (!logsResponse.ok) return [3 /*break*/, 5];
                    return [4 /*yield*/, logsResponse.text()];
                case 4:
                    logs = _b.sent();
                    if (logs) {
                        return [3 /*break*/, 6];
                    }
                    _b.label = 5;
                case 5:
                    logFileUrls_1_1 = logFileUrls_1.next();
                    return [3 /*break*/, 2];
                case 6: return [3 /*break*/, 9];
                case 7:
                    e_1_1 = _b.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 9];
                case 8:
                    try {
                        if (logFileUrls_1_1 && !logFileUrls_1_1.done && (_a = logFileUrls_1.return)) _a.call(logFileUrls_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7 /*endfinally*/];
                case 9: return [2 /*return*/, logs ? logs.split(/[\r\n]+/).filter(Boolean) : []];
            }
        });
    });
}
exports.getLogs = getLogs;
function getReportHtml(error) {
    var errorContext = (0, errorContext_1.getErrorContext)(error);
    var gameDetails = errorContext.game.version ? "Game v".concat(errorContext.game.version) : 'Unknown game version';
    var dlcDetails = getDlcListHtml(errorContext);
    var modsDetails = getModsListHtml(errorContext);
    var errorDetails = "\n        <pre style=\"font-size: smaller\">".concat(getErrorHtml(errorContext.error), "</pre>\n    ");
    return "\n        <div style=\"text-align: left\">\n            ".concat(errorDetails, "\n            ").concat(gameDetails, "\n            ").concat(dlcDetails, "\n            ").concat(modsDetails, "\n        </div>\n    ");
}
exports.getReportHtml = getReportHtml;
function getFooterHtml() {
    var createLinkHtml = function (text, url) {
        return "<a href=\"#\" onclick=\"GameStartUpWebSite.getInstance().execute('".concat(url, "')\">") +
            text.replaceAll(' ', '&nbsp;') +
            "</a>";
    };
    var inviteLink = createLinkHtml('server invite', 'https://discord.gg/remtairy');
    var channelLink = (0, errorContext_1.getErrorContext)().mods.some(function (mod) { return mod.name !== 'FastCutIns'; })
        ? createLinkHtml('mod bugs channel', 'https://discord.com/channels/454295440305946644/1114325651269369946')
        : createLinkHtml('bugs channel', 'https://discord.com/channels/454295440305946644/591771080985673729');
    return "\n        <div style=\"font-size: small\">\n            If you don't understand error message, use \"Copy report\" button to copy report to clipboard\n            and post it in ".concat(channelLink, " (").concat(inviteLink, ").\n        </div>\n    ");
}
exports.getFooterHtml = getFooterHtml;


/***/ }),

/***/ "./module/index.ts":
/*!*************************!*\
  !*** ./module/index.ts ***!
  \*************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.pathResolver = exports.loadMods = exports.getModsList = void 0;
var modsLoadersRepository_1 = __importDefault(__webpack_require__(/*! ./modsLoadersRepository */ "./module/modsLoadersRepository.ts"));
var topologicalSort_1 = __importDefault(__webpack_require__(/*! ./topologicalSort */ "./module/topologicalSort.ts"));
var notifications_1 = __webpack_require__(/*! ./notifications */ "./module/notifications.ts");
var utils_1 = __webpack_require__(/*! ./utils */ "./module/utils.ts");
var path_1 = __webpack_require__(/*! path */ "path");
var virtualFileSystem_1 = __importStar(__webpack_require__(/*! ./virtualFileSystem */ "./module/virtualFileSystem.ts"));
var logging_1 = __importDefault(__webpack_require__(/*! ./logging */ "./module/logging.ts"));
var virtualPathsStorage = new virtualFileSystem_1.default();
var isErrorDisplayed = false;
window.addEventListener('error', function (e) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!!isErrorDisplayed) return [3 /*break*/, 2];
                    isErrorDisplayed = true;
                    return [4 /*yield*/, (0, notifications_1.showFatalError)(e.error)];
                case 1:
                    _a.sent();
                    isErrorDisplayed = false;
                    _a.label = 2;
                case 2: return [2 /*return*/, false];
            }
        });
    });
});
function loadScript(url) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2 /*return*/, new Promise(function (resolve, reject) {
                    var script = document.createElement('script');
                    script.type = 'text/javascript';
                    script.src = url;
                    script.async = false;
                    script.onload = function () { return resolve(); };
                    script.onerror = reject;
                    script.onabort = reject;
                    script.onabort = reject;
                    document.body.appendChild(script);
                })];
        });
    });
}
function initializeLoaders() {
    return __awaiter(this, void 0, void 0, function () {
        var modsLoaders, loadersFolder, loadersScripts, existsSync, isFolderExist, readdirAsync, _a, _b, entry, e_1_1, loadPromises;
        var e_1, _c;
        var _this = this;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    logging_1.default.debug('Initializing mod loaders.');
                    modsLoaders = new modsLoadersRepository_1.default();
                    if ((0, utils_1.isBrowser)()) {
                        logging_1.default.info('Mod loaders are not supported in browser.');
                        return [2 /*return*/, modsLoaders];
                    }
                    loadersFolder = (0, utils_1.resolvePath)('js', 'loaders');
                    loadersScripts = [];
                    if (!(0, utils_1.isBrowser)()) return [3 /*break*/, 1];
                    return [3 /*break*/, 11];
                case 1: return [4 /*yield*/, (0, utils_1.getExistsSync)()];
                case 2:
                    existsSync = _d.sent();
                    isFolderExist = existsSync(loadersFolder);
                    if (!isFolderExist) {
                        logging_1.default.info({ loadersFolder: loadersFolder }, 'No mod loaders found');
                        return [2 /*return*/, modsLoaders];
                    }
                    return [4 /*yield*/, (0, utils_1.getReaddirAsync)()];
                case 3:
                    readdirAsync = _d.sent();
                    _d.label = 4;
                case 4:
                    _d.trys.push([4, 9, 10, 11]);
                    return [4 /*yield*/, readdirAsync(loadersFolder)];
                case 5:
                    _a = __values.apply(void 0, [_d.sent()]), _b = _a.next();
                    _d.label = 6;
                case 6:
                    if (!!_b.done) return [3 /*break*/, 8];
                    entry = _b.value;
                    if ((0, path_1.extname)(entry).toLowerCase() === '.js') {
                        loadersScripts.push(entry);
                    }
                    _d.label = 7;
                case 7:
                    _b = _a.next();
                    return [3 /*break*/, 6];
                case 8: return [3 /*break*/, 11];
                case 9:
                    e_1_1 = _d.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 11];
                case 10:
                    try {
                        if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7 /*endfinally*/];
                case 11:
                    logging_1.default.info({ loadersFolder: loadersFolder, loadersScripts: loadersScripts }, 'Mod loaders found');
                    loadPromises = loadersScripts.map(function (script) { return __awaiter(_this, void 0, void 0, function () {
                        var loaderPath, loaderModule, error_1;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    _a.trys.push([0, 2, , 3]);
                                    loaderPath = './js/loaders/' + script;
                                    return [4 /*yield*/, requireLoader(loaderPath)];
                                case 1:
                                    loaderModule = _a.sent();
                                    modsLoaders.registerLoader(loaderModule === null || loaderModule === void 0 ? void 0 : loaderModule.default);
                                    logging_1.default.info({ loader: script }, 'Loader is initialized successfully.');
                                    return [3 /*break*/, 3];
                                case 2:
                                    error_1 = _a.sent();
                                    logging_1.default.error({ loader: script, error: error_1, stack: error_1 === null || error_1 === void 0 ? void 0 : error_1.stack }, 'Failed to initialize loader');
                                    return [3 /*break*/, 3];
                                case 3: return [2 /*return*/];
                            }
                        });
                    }); });
                    return [4 /*yield*/, Promise.all(loadPromises)];
                case 12:
                    _d.sent();
                    return [2 /*return*/, modsLoaders];
            }
        });
    });
}
function requireLoader(loaderPath) {
    return __awaiter(this, void 0, void 0, function () {
        var loaderScript;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, utils_1.queryFile)(loaderPath)];
                case 1:
                    loaderScript = _a.sent();
                    return [2 /*return*/, executeLoaderModule(loaderScript)];
            }
        });
    });
}
function executeLoaderModule(script) {
    var module = {
        exports: {}
    };
    eval(script);
    return module.exports;
}
function getLoaders() {
    return __awaiter(this, void 0, void 0, function () {
        var modsLoadersRepository;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, initializeLoaders()];
                case 1:
                    modsLoadersRepository = _a.sent();
                    return [2 /*return*/, modsLoadersRepository.getLoaders()];
            }
        });
    });
}
function detectMods(loaders) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        var aggregatedMods, loaders_1, loaders_1_1, loader, modsLocations, modsLocations_1, modsLocations_1_1, location_1, modsDetector, _b, mods, dependencies, mods_1, mods_1_1, mod, dependencies_1, dependencies_1_1, dependency, mod, e_2_1, e_3_1;
        var e_3, _c, e_2, _d, e_4, _e, e_5, _f;
        return __generator(this, function (_g) {
            switch (_g.label) {
                case 0:
                    aggregatedMods = new Map();
                    loaders.sort(function (firstLoader, secondLoader) { return firstLoader.getOrder() - secondLoader.getOrder(); });
                    _g.label = 1;
                case 1:
                    _g.trys.push([1, 13, 14, 15]);
                    loaders_1 = __values(loaders), loaders_1_1 = loaders_1.next();
                    _g.label = 2;
                case 2:
                    if (!!loaders_1_1.done) return [3 /*break*/, 12];
                    loader = loaders_1_1.value;
                    return [4 /*yield*/, loader.getPaths(virtualPathsStorage)];
                case 3:
                    modsLocations = _g.sent();
                    logging_1.default.info({ loader: loader.name, modsLocations: modsLocations }, 'Loader resolved mods locations');
                    _g.label = 4;
                case 4:
                    _g.trys.push([4, 9, 10, 11]);
                    modsLocations_1 = (e_2 = void 0, __values(modsLocations)), modsLocations_1_1 = modsLocations_1.next();
                    _g.label = 5;
                case 5:
                    if (!!modsLocations_1_1.done) return [3 /*break*/, 8];
                    location_1 = modsLocations_1_1.value;
                    modsDetector = loader.getModsDetector();
                    return [4 /*yield*/, modsDetector.detect(location_1)];
                case 6:
                    _b = _g.sent(), mods = _b.mods, dependencies = _b.dependencies;
                    logging_1.default.info({ location: location_1, mods: mods.map(function (mod) { return mod.name; }) }, 'Mods found');
                    try {
                        for (mods_1 = (e_4 = void 0, __values(mods)), mods_1_1 = mods_1.next(); !mods_1_1.done; mods_1_1 = mods_1.next()) {
                            mod = mods_1_1.value;
                            if (aggregatedMods.has(mod.name)) {
                                throw new Error("Detected mods with duplicate names: '".concat(mod.name, "'.\n") +
                                    "Either remove '".concat(mod.name, "' from '").concat(loader.name, "' or from '").concat((_a = aggregatedMods.get(mod.name)) === null || _a === void 0 ? void 0 : _a.source, "'."));
                            }
                            aggregatedMods.set(mod.name, __assign(__assign({}, mod), { source: loader.name, location: location_1 }));
                        }
                    }
                    catch (e_4_1) { e_4 = { error: e_4_1 }; }
                    finally {
                        try {
                            if (mods_1_1 && !mods_1_1.done && (_e = mods_1.return)) _e.call(mods_1);
                        }
                        finally { if (e_4) throw e_4.error; }
                    }
                    try {
                        for (dependencies_1 = (e_5 = void 0, __values(dependencies)), dependencies_1_1 = dependencies_1.next(); !dependencies_1_1.done; dependencies_1_1 = dependencies_1.next()) {
                            dependency = dependencies_1_1.value;
                            mod = aggregatedMods.get(dependency[0]);
                            if (!mod) {
                                throw new Error("Unable to resolve mod from dependency: ".concat(JSON.stringify(dependency)));
                            }
                            if (!mod.requiredBy) {
                                mod.requiredBy = [];
                            }
                            mod.requiredBy.push(dependency[1]);
                        }
                    }
                    catch (e_5_1) { e_5 = { error: e_5_1 }; }
                    finally {
                        try {
                            if (dependencies_1_1 && !dependencies_1_1.done && (_f = dependencies_1.return)) _f.call(dependencies_1);
                        }
                        finally { if (e_5) throw e_5.error; }
                    }
                    _g.label = 7;
                case 7:
                    modsLocations_1_1 = modsLocations_1.next();
                    return [3 /*break*/, 5];
                case 8: return [3 /*break*/, 11];
                case 9:
                    e_2_1 = _g.sent();
                    e_2 = { error: e_2_1 };
                    return [3 /*break*/, 11];
                case 10:
                    try {
                        if (modsLocations_1_1 && !modsLocations_1_1.done && (_d = modsLocations_1.return)) _d.call(modsLocations_1);
                    }
                    finally { if (e_2) throw e_2.error; }
                    return [7 /*endfinally*/];
                case 11:
                    loaders_1_1 = loaders_1.next();
                    return [3 /*break*/, 2];
                case 12: return [3 /*break*/, 15];
                case 13:
                    e_3_1 = _g.sent();
                    e_3 = { error: e_3_1 };
                    return [3 /*break*/, 15];
                case 14:
                    try {
                        if (loaders_1_1 && !loaders_1_1.done && (_c = loaders_1.return)) _c.call(loaders_1);
                    }
                    finally { if (e_3) throw e_3.error; }
                    return [7 /*endfinally*/];
                case 15: return [2 /*return*/, aggregatedMods];
            }
        });
    });
}
function getModUrl(mod) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2 /*return*/, (0, virtualFileSystem_1.convertPathToUrl)((0, path_1.join)(mod.location, mod.name + '.js'))];
        });
    });
}
function getModsList() {
    return __awaiter(this, void 0, void 0, function () {
        var loaders, mods_2, dependencies, _a, _b, mod, _c, _d, dependency, orderedModNames, err_1;
        var e_6, _e, e_7, _f;
        return __generator(this, function (_g) {
            switch (_g.label) {
                case 0:
                    _g.trys.push([0, 3, , 5]);
                    return [4 /*yield*/, getLoaders()];
                case 1:
                    loaders = _g.sent();
                    return [4 /*yield*/, detectMods(loaders)];
                case 2:
                    mods_2 = _g.sent();
                    dependencies = [];
                    try {
                        for (_a = __values(mods_2.values()), _b = _a.next(); !_b.done; _b = _a.next()) {
                            mod = _b.value;
                            if (mod.requiredBy) {
                                try {
                                    for (_c = (e_7 = void 0, __values(mod.requiredBy)), _d = _c.next(); !_d.done; _d = _c.next()) {
                                        dependency = _d.value;
                                        dependencies.push([mod.name, dependency]);
                                    }
                                }
                                catch (e_7_1) { e_7 = { error: e_7_1 }; }
                                finally {
                                    try {
                                        if (_d && !_d.done && (_f = _c.return)) _f.call(_c);
                                    }
                                    finally { if (e_7) throw e_7.error; }
                                }
                            }
                        }
                    }
                    catch (e_6_1) { e_6 = { error: e_6_1 }; }
                    finally {
                        try {
                            if (_b && !_b.done && (_e = _a.return)) _e.call(_a);
                        }
                        finally { if (e_6) throw e_6.error; }
                    }
                    orderedModNames = (0, topologicalSort_1.default)(__spreadArray([], __read(mods_2.keys()), false), dependencies);
                    return [2 /*return*/, orderedModNames
                            .map(function (name) {
                            var modInfo = mods_2.get(name);
                            if (!modInfo) {
                                throw new Error("Missing mod '".concat(name, "'."));
                            }
                            return modInfo;
                        })];
                case 3:
                    err_1 = _g.sent();
                    return [4 /*yield*/, (0, notifications_1.showFatalError)(err_1)];
                case 4: return [2 /*return*/, _g.sent()];
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.getModsList = getModsList;
function loadMods(mods) {
    return __awaiter(this, void 0, void 0, function () {
        var mods_3, mods_3_1, mod, modName, _a, err_2, e_8_1, err_3;
        var e_8, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    _c.trys.push([0, 15, , 17]);
                    _c.label = 1;
                case 1:
                    _c.trys.push([1, 12, 13, 14]);
                    mods_3 = __values(mods), mods_3_1 = mods_3.next();
                    _c.label = 2;
                case 2:
                    if (!!mods_3_1.done) return [3 /*break*/, 11];
                    mod = mods_3_1.value;
                    modName = (0, utils_1.getDetailedName)(mod);
                    _c.label = 3;
                case 3:
                    _c.trys.push([3, 6, , 10]);
                    logging_1.default.info({ modName: modName }, 'Loading mod');
                    _a = loadScript;
                    return [4 /*yield*/, getModUrl(mod)];
                case 4: return [4 /*yield*/, _a.apply(void 0, [_c.sent()])];
                case 5:
                    _c.sent();
                    return [3 /*break*/, 10];
                case 6:
                    err_2 = _c.sent();
                    if (!mod.parameters.optional) return [3 /*break*/, 7];
                    logging_1.default.warn({ modName: modName }, 'Failed to load optional mod.');
                    return [3 /*break*/, 9];
                case 7: return [4 /*yield*/, (0, notifications_1.showMissingModError)(mod, mods)];
                case 8: return [2 /*return*/, _c.sent()];
                case 9: return [3 /*break*/, 10];
                case 10:
                    mods_3_1 = mods_3.next();
                    return [3 /*break*/, 2];
                case 11: return [3 /*break*/, 14];
                case 12:
                    e_8_1 = _c.sent();
                    e_8 = { error: e_8_1 };
                    return [3 /*break*/, 14];
                case 13:
                    try {
                        if (mods_3_1 && !mods_3_1.done && (_b = mods_3.return)) _b.call(mods_3);
                    }
                    finally { if (e_8) throw e_8.error; }
                    return [7 /*endfinally*/];
                case 14: return [3 /*break*/, 17];
                case 15:
                    err_3 = _c.sent();
                    return [4 /*yield*/, (0, notifications_1.showFatalError)(err_3)];
                case 16: return [2 /*return*/, _c.sent()];
                case 17: return [2 /*return*/];
            }
        });
    });
}
exports.loadMods = loadMods;
exports.pathResolver = virtualPathsStorage;


/***/ }),

/***/ "./module/logging.ts":
/*!***************************!*\
  !*** ./module/logging.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.defaultLogPath = void 0;
var package_json_1 = __webpack_require__(/*! ../package.json */ "./package.json");
var logger_1 = __webpack_require__(/*! @libs/logger */ "@libs/logger");
Object.defineProperty(exports, "defaultLogPath", ({ enumerable: true, get: function () { return logger_1.defaultLogPath; } }));
var logger = (0, logger_1.createDefaultLogger)(package_json_1.name);
exports["default"] = logger;


/***/ }),

/***/ "./module/modsLoadersRepository.ts":
/*!*****************************************!*\
  !*** ./module/modsLoadersRepository.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var logger_1 = __webpack_require__(/*! @libs/logger */ "@libs/logger");
var sweetalert_1 = __importDefault(__webpack_require__(/*! @libs/sweetalert */ "@libs/sweetalert"));
var ModsLoadersRepository = /** @class */ (function () {
    function ModsLoadersRepository() {
        this.modsLoaders = {};
    }
    ModsLoadersRepository.prototype.registerLoader = function (loaderConstructor) {
        if (!loaderConstructor) {
            throw new Error('Loader module is missing default export');
        }
        var loader = new loaderConstructor(logger_1.createDefaultLogger, sweetalert_1.default);
        if (!(loader === null || loader === void 0 ? void 0 : loader.name) || !(loader === null || loader === void 0 ? void 0 : loader.getPaths)) {
            throw new Error("Invalid mod loader: ".concat(JSON.stringify(loader)));
        }
        if (loader.name in this.modsLoaders) {
            throw new Error("Loader with name '".concat(loader.name, "' already exists."));
        }
        this.modsLoaders[loader.name] = loader;
    };
    ModsLoadersRepository.prototype.getLoaders = function () {
        return Object.values(this.modsLoaders);
    };
    return ModsLoadersRepository;
}());
exports["default"] = ModsLoadersRepository;


/***/ }),

/***/ "./module/notifications.ts":
/*!*********************************!*\
  !*** ./module/notifications.ts ***!
  \*********************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.showFatalError = exports.showMissingModError = void 0;
var errorPrinter_1 = __webpack_require__(/*! ./errorPrinter */ "./module/errorPrinter.ts");
var utils_1 = __webpack_require__(/*! ./utils */ "./module/utils.ts");
var errorContext_1 = __webpack_require__(/*! ./errorContext */ "./module/errorContext.ts");
var sweetalert_1 = __importDefault(__webpack_require__(/*! @libs/sweetalert */ "@libs/sweetalert"));
var logging_1 = __importDefault(__webpack_require__(/*! ./logging */ "./module/logging.ts"));
function restart() {
    location.reload();
    logging_1.default.info('Restarting...');
    throw new Error('Restart');
}
function wrapJson(report) {
    var maxJsonMessageLength = 1900;
    if (report.length > maxJsonMessageLength) {
        return report;
    }
    return '```json\n' + report + '\n```';
}
function showMissingModError(mod, mods) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        var getModName, dependentMods;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    getModName = function (mod) { return mod.parameters.displayedName || mod.name; };
                    dependentMods = ((_a = mod.requiredBy) !== null && _a !== void 0 ? _a : []).map(function (name) {
                        var dependencyInfo = mods.filter(function (m) { return m.name === name; })[0];
                        var dependencyName = getModName(dependencyInfo) || name;
                        return "<pre><b>".concat(dependencyName, "</b></pre>");
                    });
                    // TODO: Search mod in steam.
                    return [4 /*yield*/, sweetalert_1.default.fire({
                            title: "Failed to load mod '".concat(getModName(mod), "'"),
                            html: "\n            Mod ".concat((0, utils_1.getDetailedName)(mod), " is missing.<br>\n            Following mods depend on it: ").concat(dependentMods.join("\n"), "\n            Make sure to read mod's README (\"Requirements\"&nbsp;section) and install all requirements.\n        "),
                            icon: 'error',
                            confirmButtonText: 'Restart',
                            allowOutsideClick: false,
                            showConfirmButton: true,
                        })];
                case 1:
                    // TODO: Search mod in steam.
                    _b.sent();
                    return [2 /*return*/, restart()];
            }
        });
    });
}
exports.showMissingModError = showMissingModError;
function showFatalError(error) {
    return __awaiter(this, void 0, void 0, function () {
        var reportHtml, footer, result, logs, getSerializableError, errorText, maxLogsLinesNumber, logsLines, report, clipboard;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (error) {
                        logging_1.default.error(error, 'Fatal error');
                    }
                    if (typeof SceneManager !== 'undefined') {
                        SceneManager.stop();
                    }
                    reportHtml = (0, errorPrinter_1.getReportHtml)(error);
                    footer = (0, errorPrinter_1.getFooterHtml)();
                    _a.label = 1;
                case 1:
                    if (!sweetalert_1.default.isVisible()) return [3 /*break*/, 3];
                    return [4 /*yield*/, (0, utils_1.sleep)(500)];
                case 2:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 3: return [4 /*yield*/, sweetalert_1.default.fire({
                        icon: 'error',
                        title: "Unexpected error",
                        html: reportHtml,
                        footer: footer,
                        cancelButtonText: 'Copy report',
                        confirmButtonText: 'Restart',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        showCancelButton: true,
                        showConfirmButton: true,
                    })];
                case 4:
                    result = _a.sent();
                    if (!(result.isDismissed && result.dismiss === sweetalert_1.default.DismissReason.cancel)) return [3 /*break*/, 6];
                    return [4 /*yield*/, (0, errorPrinter_1.getLogs)()];
                case 5:
                    logs = _a.sent();
                    getSerializableError = function (err) {
                        return {
                            message: err.toString(),
                            stack: (err.stack || '').split('\n')
                        };
                    };
                    errorText = JSON.stringify(__assign(__assign({}, (0, errorContext_1.getErrorContext)()), { error: getSerializableError(error) }), null, 2);
                    maxLogsLinesNumber = 100;
                    logsLines = logs
                        .slice(-maxLogsLinesNumber)
                        .map(function (log) { return '\n    ' + log; });
                    report = errorText.slice(0, -1) +
                        '  "logs": [' + logsLines.join(',') + '\n' +
                        '  ]\n' +
                        errorText[errorText.length - 1];
                    if (nw.Clipboard) {
                        clipboard = nw.Clipboard.get();
                        clipboard.set(wrapJson(report), 'text');
                    }
                    _a.label = 6;
                case 6:
                    if (result.isConfirmed) {
                        return [2 /*return*/, restart()];
                    }
                    _a.label = 7;
                case 7:
                    if (true) return [3 /*break*/, 1];
                    _a.label = 8;
                case 8: return [2 /*return*/];
            }
        });
    });
}
exports.showFatalError = showFatalError;


/***/ }),

/***/ "./module/replaceAllPolyfill.ts":
/*!**************************************!*\
  !*** ./module/replaceAllPolyfill.ts ***!
  \**************************************/
/***/ (() => {


if (!String.prototype.replaceAll) {
    String.prototype.replaceAll = function (str, newStr) {
        if (typeof newStr !== 'string') {
            throw new Error('Not supported');
        }
        if (Object.prototype.toString.call(str).toLowerCase() === '[object regexp]') {
            return this.replace(str, newStr);
        }
        return this.replace(new RegExp(str, 'g'), newStr);
    };
}


/***/ }),

/***/ "./module/topologicalSort.ts":
/*!***********************************!*\
  !*** ./module/topologicalSort.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
function topologicalSort(nodes, edges) {
    var cursor = nodes.length;
    var i = cursor;
    var sorted = new Array(cursor);
    var visited = {};
    var outgoingEdges = makeOutgoingEdges(edges);
    var nodesHash = makeNodesHash(nodes);
    // check for unknown nodes
    edges.forEach(function (edge) {
        if (!nodesHash.has(edge[0]) || !nodesHash.has(edge[1])) {
            throw new Error("Unknown node. There is an unknown node in the supplied edges: ".concat(JSON.stringify(edge), "."));
        }
    });
    while (i--) {
        if (!visited[i])
            visit(nodes[i], i, new Set());
    }
    return sorted;
    function visit(node, i, predecessors) {
        if (predecessors.has(node)) {
            var nodeRep = void 0;
            try {
                nodeRep = ", node was:" + JSON.stringify(node);
            }
            catch (e) {
                nodeRep = "";
            }
            throw new Error('Cyclic dependency' + nodeRep);
        }
        if (!nodesHash.has(node)) {
            throw new Error('Found unknown node. Make sure to provided all involved nodes. Unknown node: ' + JSON.stringify(node));
        }
        if (visited[i])
            return;
        visited[i] = true;
        var outgoing = Array.from(outgoingEdges.get(node) || new Set());
        i = outgoing.length;
        if (i) {
            predecessors.add(node);
            do {
                var child = outgoing[--i];
                var nodeHash = nodesHash.get(child);
                if (nodeHash == undefined) {
                    throw new Error('Node hash is missing. Node: ' + JSON.stringify(node));
                }
                visit(child, nodeHash, predecessors);
            } while (i);
            predecessors.delete(node);
        }
        sorted[--cursor] = node;
    }
}
exports["default"] = topologicalSort;
function makeOutgoingEdges(arr) {
    var _a;
    var edges = new Map();
    for (var i = 0, len = arr.length; i < len; i++) {
        var edge = arr[i];
        if (!edges.has(edge[0]))
            edges.set(edge[0], new Set());
        if (!edges.has(edge[1]))
            edges.set(edge[1], new Set());
        (_a = edges.get(edge[0])) === null || _a === void 0 ? void 0 : _a.add(edge[1]);
    }
    return edges;
}
function makeNodesHash(arr) {
    var res = new Map();
    for (var i = 0, len = arr.length; i < len; i++) {
        res.set(arr[i], i);
    }
    return res;
}


/***/ }),

/***/ "./module/utils.ts":
/*!*************************!*\
  !*** ./module/utils.ts ***!
  \*************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getFsAsync = exports.isBrowser = exports.getExistsSync = exports.getReaddirAsync = exports.ensureFsFunction = exports.queryFile = exports.getUniversalPath = exports.toUrl = exports.getRelativePath = exports.resolvePath = exports.getDetailedName = exports.isAndroid = exports.sleep = void 0;
var path_1 = __importDefault(__webpack_require__(/*! path */ "path"));
var util_1 = __webpack_require__(/*! util */ "util");
var process = __importStar(__webpack_require__(/*! process */ "process"));
function sleep(ms) {
    return new Promise(function (resolve) { return setTimeout(resolve, ms); });
}
exports.sleep = sleep;
var emulatorsList = new Set(['joiplay', 'maldives']);
function isAndroid() {
    return !!process.env.USER && emulatorsList.has(process.env.USER);
}
exports.isAndroid = isAndroid;
function getDetailedName(mod) {
    return mod.parameters.displayedName
        ? "'".concat(mod.parameters.displayedName, "' (").concat(mod.name, ")")
        : "'".concat(mod.name, "'");
}
exports.getDetailedName = getDetailedName;
function resolvePath() {
    var _a;
    var localPath = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        localPath[_i] = arguments[_i];
    }
    var rootFolder = path_1.default.dirname(((_a = process.mainModule) === null || _a === void 0 ? void 0 : _a.filename) || '');
    return path_1.default.resolve.apply(path_1.default, __spreadArray([rootFolder], __read(localPath), false));
}
exports.resolvePath = resolvePath;
function getRelativePath(absolutePath) {
    var _a;
    return path_1.default.relative(path_1.default.dirname(((_a = process.mainModule) === null || _a === void 0 ? void 0 : _a.filename) || ''), resolvePath(absolutePath));
}
exports.getRelativePath = getRelativePath;
function toUrl(filePath) {
    return getUniversalPath(getRelativePath(filePath));
}
exports.toUrl = toUrl;
function getUniversalPath(location) {
    return path_1.default.sep === path_1.default.posix.sep
        ? location
        : location.split(path_1.default.sep).join(path_1.default.posix.sep);
}
exports.getUniversalPath = getUniversalPath;
function queryFile(filePath) {
    return __awaiter(this, void 0, void 0, function () {
        var response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, fetch(toUrl(filePath))];
                case 1:
                    response = _a.sent();
                    return [4 /*yield*/, response.text()];
                case 2: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.queryFile = queryFile;
function ensureFsFunction(name) {
    var func = __webpack_require__(/*! fs */ "fs")[name];
    if (typeof func !== 'function') {
        throw new Error("Function '".concat(name, "' is not supported in fs API."));
    }
    return func;
}
exports.ensureFsFunction = ensureFsFunction;
function getReaddirAsync() {
    var _a, _b, _c;
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0: return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(__webpack_require__(/*! fs */ "fs")); })];
                case 1: return [2 /*return*/, (_c = (_b = (_a = (_d.sent())) === null || _a === void 0 ? void 0 : _a.promises) === null || _b === void 0 ? void 0 : _b.readdir) !== null && _c !== void 0 ? _c : (0, util_1.promisify)(ensureFsFunction('readdir'))];
            }
        });
    });
}
exports.getReaddirAsync = getReaddirAsync;
function getExistsSync() {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(__webpack_require__(/*! fs */ "fs")); })];
                case 1: return [2 /*return*/, (_a.sent()).existsSync];
            }
        });
    });
}
exports.getExistsSync = getExistsSync;
function isBrowser() {
    return (typeof globalThis.require !== 'function') || (typeof process !== 'object');
}
exports.isBrowser = isBrowser;
function getFsAsync(getAsyncFs, getCallbackFs, getSyncFs) {
    var asyncFs = getAsyncFs();
    if (asyncFs) {
        return asyncFs;
    }
    console.warn("Promise version of function '".concat(getAsyncFs, "' is not supported in current fs API. ") +
        'Falling back to callback implementation.');
    var callbackFs = getCallbackFs();
    if (callbackFs) {
        return (0, util_1.promisify)(getCallbackFs);
    }
    console.warn("Callback version of function '".concat(getCallbackFs, "' is not supported in current fs API. ") +
        'Falling back to sync implementation.');
    var syncFunction = getSyncFs();
    if (!syncFunction) {
        throw new Error("Function '".concat(getSyncFs, "' is not supported in fs API."));
    }
    return (function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return new Promise(function (resolve, reject) {
            try {
                var result = syncFunction.apply({}, args);
                resolve(result);
            }
            catch (error) {
                reject(error);
            }
        });
    });
}
exports.getFsAsync = getFsAsync;


/***/ }),

/***/ "./module/virtualFileSystem.ts":
/*!*************************************!*\
  !*** ./module/virtualFileSystem.ts ***!
  \*************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.convertUrlToPath = exports.convertPathToUrl = void 0;
var path_1 = __importDefault(__webpack_require__(/*! path */ "path"));
__webpack_require__(/*! ./replaceAllPolyfill */ "./module/replaceAllPolyfill.ts");
var logging_1 = __importDefault(__webpack_require__(/*! ./logging */ "./module/logging.ts"));
var utils_1 = __webpack_require__(/*! ./utils */ "./module/utils.ts");
var VirtualPathStorage = /** @class */ (function () {
    function VirtualPathStorage() {
        this.virtualToRealPathMappings = new Map();
    }
    VirtualPathStorage.prototype.add = function (virtualPath, realPath) {
        virtualPath = (0, utils_1.resolvePath)(virtualPath);
        realPath = (0, utils_1.resolvePath)(realPath);
        var duplicatedPath = this.virtualToRealPathMappings.get(virtualPath);
        if (duplicatedPath) {
            logging_1.default.warn({ realPath: realPath, duplicatedPath: duplicatedPath }, "Detected conflicting paths.");
        }
        this.virtualToRealPathMappings.set(virtualPath, realPath);
    };
    VirtualPathStorage.prototype.resolve = function (virtualPath) {
        virtualPath = (0, utils_1.resolvePath)(virtualPath);
        return this.virtualToRealPathMappings.get(virtualPath) || virtualPath;
    };
    VirtualPathStorage.prototype.resolveUrl = function (virtualUrl) {
        var virtualPath = convertUrlToPath(virtualUrl);
        var realPath = this.resolve(virtualPath);
        return convertPathToUrl(realPath);
    };
    return VirtualPathStorage;
}());
exports["default"] = VirtualPathStorage;
function convertPathToUrl(location) {
    return (0, utils_1.getRelativePath)(location).replaceAll(path_1.default.sep, '/');
}
exports.convertPathToUrl = convertPathToUrl;
function convertUrlToPath(location) {
    return (0, utils_1.resolvePath)(location.replaceAll('/', path_1.default.sep));
}
exports.convertUrlToPath = convertUrlToPath;


/***/ }),

/***/ "fs":
/*!*********************!*\
  !*** external "fs" ***!
  \*********************/
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ "path":
/*!***********************!*\
  !*** external "path" ***!
  \***********************/
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ "process":
/*!**************************!*\
  !*** external "process" ***!
  \**************************/
/***/ ((module) => {

module.exports = require("process");

/***/ }),

/***/ "util":
/*!***********************!*\
  !*** external "util" ***!
  \***********************/
/***/ ((module) => {

module.exports = require("util");

/***/ }),

/***/ "@libs/sweetalert":
/*!************************!*\
  !*** external "Alert" ***!
  \************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE__libs_sweetalert__;

/***/ }),

/***/ "@libs/logger":
/*!*************************!*\
  !*** external "Logger" ***!
  \*************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE__libs_logger__;

/***/ }),

/***/ "./package.json":
/*!**********************!*\
  !*** ./package.json ***!
  \**********************/
/***/ ((module) => {

module.exports = JSON.parse('{"name":"mod-manager","version":"2.0.4","license":"MIT","private":true,"scripts":{"build":"npx webpack","watch":"npx nodemon"},"devDependencies":{"@types/node":"^18.11.9","@types/nw.js":"^0.13.17","@types/pixi.js":"^4","@types/webpack":"^5.28.5","@wangdevops/greenworks":"^1.2.0","css-loader":"^6.9.1","memfs":"^4.6.0","node-sass":"^9.0.0","nodemon":"^3.0.3","sass":"^1.70.0","sass-loader":"^14.0.0","style-loader":"^3.3.4","ts-loader":"^9.5.1","ts-node":"^10.9.2","typescript":"^4.9.5","webpack":"^5.89.0","webpack-cli":"^5.1.4","webpack-merge":"^5.10.0"},"dependencies":{"@sweetalert2/theme-borderless":"^5.0.16","assert":"^2.1.0","buffer":"^6.0.3","core-js":"^3.35.1","crypto-browserify":"^3.12.0","es5-shim":"^4.6.7","https-browserify":"^1.0.0","os-browserify":"^0.3.0","path-browserify":"^1.0.1","pino":"^8.17.2","pino-pretty":"^10.3.1","process":"^0.11.10","stream-browserify":"^3.0.0","stream-http":"^3.2.0","sweetalert2":"^11.10.3","url":"^0.11.3","util":"^0.12.5"}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./module/index.ts");
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=modManager.js.map